<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Home::index');
$routes->get('/fetch-emendas/(:num)', 'Home::fetchEmendasByAno/$1');
$routes->get('/fetch-arquivos/(:num)', 'Home::fetchArquivosByEmenda/$1');




$routes->get('/login', 'AuthController::login');
$routes->post('/auth/authenticate', 'AuthController::authenticate');
$routes->get('/logout', 'AuthController::logout');
$routes->get('/dashboard', 'DashboardController::index');

// Rotas para Anos
$routes->get('/anos', 'Ano::index');
$routes->get('/anos/create', 'Ano::create');
$routes->post('/anos/store', 'Ano::store');
$routes->get('/anos/delete/(:num)', 'Ano::delete/$1');

// Rotas para Tipos
$routes->get('/tipos', 'Tipo::index');
$routes->get('/tipos/create', 'Tipo::create');
$routes->post('/tipos/store', 'Tipo::store');
$routes->get('/tipos/delete/(:num)', 'Tipo::delete/$1');

// Rotas para Emendas
$routes->get('/emenda', 'EmendaController::index');            // Lista de emendas
$routes->get('/emenda/create', 'EmendaController::create');     // Formulário para criar nova emenda
$routes->post('/emenda/store', 'EmendaController::store');      // Salvar nova emenda
$routes->get('/emenda/edit/(:num)', 'EmendaController::edit/$1'); // Formulário para editar emenda específica
$routes->post('/emenda/update/(:num)', 'EmendaController::update/$1'); // Atualizar emenda específica
$routes->get('/emenda/delete/(:num)', 'EmendaController::delete/$1');  // Excluir emenda específica
$routes->get('/emenda/deleteArquivo/(:num)', 'EmendaController::deleteArquivo/$1');
$routes->get('/emenda/downloadArquivo/(:num)', 'EmendaController::downloadArquivo/$1');
$routes->get('/emenda/public', 'EmendaController::publicView');
$routes->get('/emenda/fetchEmendasByYear/(:num)', 'EmendaController::fetchEmendasByYear/$1');
$routes->get('/emenda/fetchArquivosByEmenda/(:num)', 'EmendaController::fetchArquivosByEmenda/$1');


