<?php

namespace App\Controllers;

use App\Models\EmendaModel;
use App\Models\TipoModel;
use App\Models\EmendaArquivoModel;
use App\Models\AnoModel;


class EmendaController extends BaseController
{
    public function index()
    {
        $emendaModel = new EmendaModel();
        $anoModel = new AnoModel();
        $tipoModel = new TipoModel();

        $anoId = $this->request->getGet('ano_id');
        $tipoId = $this->request->getGet('tipo_id');

        // Inicie a consulta das emendas
        $query = $emendaModel;

        // Aplique o filtro por ano, se fornecido
        if (!empty($anoId)) {
            $query = $query->where('ano_id', $anoId);
        }

        // Aplique o filtro por tipo, se fornecido
        if (!empty($tipoId)) {
            $query = $query->where('tipo_id', $tipoId);
        }

        // Recupere os resultados filtrados
        $data['emendas'] = $query->findAll();
        $data['anos'] = $anoModel->findAll();
        $data['tipos'] = $tipoModel->findAll();

        return view('emenda/index', $data);
    }





    public function create()
    {
        $tipoModel = new TipoModel();
        $anoModel = new AnoModel();
        $data['tipos'] = $tipoModel->findAll();
        $data['anos'] = $anoModel->findAll(); // Carrega os anos disponíveis

        return view('emenda/create', $data);
    }

    public function store()
    {
        $emendaModel = new EmendaModel();
        $emendaArquivoModel = new EmendaArquivoModel();

        $data = [
            'tipo_id' => $this->request->getPost('tipo_id'),
            'ano_id' => $this->request->getPost('ano_id'), // Adicionando ano_id
            'numero' => $this->request->getPost('numero'),
            'objeto' => $this->request->getPost('objeto'),
            'vereador' => $this->request->getPost('vereador'),
            'valor' => $this->request->getPost('valor'),
            'suplementacao' => $this->request->getPost('suplementacao'),
            'total' => $this->request->getPost('total'),
            'dotacao' => $this->request->getPost('dotacao'),
            'empenho' => $this->request->getPost('empenho'),
            'situacao' => $this->request->getPost('situacao'),
        ];

        $emendaId = $emendaModel->insert($data);

        // Manipulação de upload de arquivos
        if ($files = $this->request->getFiles()) {
            foreach ($files['documentos'] as $file) {
                if ($file->isValid() && !$file->hasMoved()) {
                    $originalName = $file->getClientName();
                    $fileType = $file->getMimeType();
                    $fileSize = $file->getSize();
                    $newName = $file->getRandomName();
                    $filePath = 'uploads/' . $newName; // Caminho completo com o nome gerado aleatoriamente

                    $file->move(WRITEPATH . 'uploads', $newName);

                    // Salva o caminho com o nome gerado no banco de dados
                    $emendaArquivoModel->insert([
                        'emenda_id' => $emendaId,
                        'nome_arquivo' => $originalName, // Nome original do arquivo para referência
                        'caminho' => $filePath,          // Caminho gerado aleatoriamente para recuperação
                        'tipo' => $fileType,
                        'tamanho' => $fileSize,
                    ]);
                }
            }
        }

        session()->setFlashdata('success', 'Emenda cadastrada com sucesso!');
        return redirect()->to('/emenda');
    }



    public function edit($id)
    {
        $emendaModel = new EmendaModel();
        $tipoModel = new TipoModel();
        $anoModel = new AnoModel();
        $emendaArquivoModel = new EmendaArquivoModel();

        $data['emenda'] = $emendaModel->find($id);
        if (!$data['emenda']) {
            throw new \CodeIgniter\Exceptions\PageNotFoundException('Emenda não encontrada');
        }

        $data['tipos'] = $tipoModel->findAll();
        $data['anos'] = $anoModel->findAll(); //
        $data['arquivos'] = $emendaArquivoModel->where('emenda_id', $id)->findAll();

        // Construir o link completo para o download do arquivo
        foreach ($data['arquivos'] as $key => $arquivo) {
            $data['arquivos'][$key]['caminho'] = base_url('writable/' . $arquivo['caminho']); // Usar o caminho salvo no banco
        }

        return view('emenda/edit', $data);
    }



    public function downloadArquivo($arquivoId)
    {
        $emendaArquivoModel = new EmendaArquivoModel();
        $arquivo = $emendaArquivoModel->find($arquivoId);

        if ($arquivo) {
            // Verifica o caminho completo do arquivo com WRITEPATH para apontar para o diretório writable
            $filePath = WRITEPATH . $arquivo['caminho'];

            if (file_exists($filePath)) {
                // Força o download do arquivo com o nome original
                return $this->response->download($filePath, null)->setFileName($arquivo['nome_arquivo']);
            } else {
                // Se o arquivo não for encontrado, redireciona com uma mensagem de erro
                session()->setFlashdata('error', 'Arquivo não encontrado no servidor.');
                return redirect()->back();
            }
        } else {
            // Se o registro no banco de dados não existir, redireciona com uma mensagem de erro
            session()->setFlashdata('error', 'Registro do arquivo não encontrado no banco de dados.');
            return redirect()->back();
        }
    }

    public function update($id)
    {
        $emendaModel = new EmendaModel();
        $emendaArquivoModel = new EmendaArquivoModel();

        // Dados da emenda
        $data = [
            'tipo_id' => $this->request->getPost('tipo_id'),
            'numero' => $this->request->getPost('numero'),
            'objeto' => $this->request->getPost('objeto'),
            'vereador' => $this->request->getPost('vereador'),
            'valor' => $this->request->getPost('valor'),
            'suplementacao' => $this->request->getPost('suplementacao'),
            'total' => $this->request->getPost('total'),
            'dotacao' => $this->request->getPost('dotacao'),
            'empenho' => $this->request->getPost('empenho'),
            'situacao' => $this->request->getPost('situacao'),
        ];

        // Atualizar dados da emenda
        $emendaModel->update($id, $data);

        // Manipulação de upload de novos arquivos
        if ($files = $this->request->getFiles()) {
            foreach ($files['documentos'] as $file) {
                if ($file->isValid() && !$file->hasMoved()) {
                    $originalName = $file->getClientName();
                    $fileType = $file->getMimeType();
                    $fileSize = $file->getSize();
                    $newName = $file->getRandomName();
                    $filePath = 'uploads/' . $newName; // Caminho completo com o nome gerado aleatoriamente

                    $file->move(WRITEPATH . 'uploads', $newName);

                    // Salva o caminho com o nome gerado e os detalhes do arquivo no banco de dados
                    $emendaArquivoModel->insert([
                        'emenda_id' => $id,
                        'nome_arquivo' => $originalName,
                        'caminho' => $filePath, // Caminho completo
                        'tipo' => $fileType,
                        'tamanho' => $fileSize,
                    ]);
                }
            }
        }

        // Adiciona mensagem de sucesso
        session()->setFlashdata('success', 'Emenda atualizada com sucesso!');

        // Redireciona para a lista de emendas
        return redirect()->to('/emenda');
    }



    public function delete($id)
    {
        $emendaModel = new EmendaModel();
        $emendaArquivoModel = new EmendaArquivoModel();

        $arquivos = $emendaArquivoModel->where('emenda_id', $id)->findAll();
        foreach ($arquivos as $arquivo) {
            $filePath = WRITEPATH . 'uploads/' . $arquivo['path_arquivo'];
            if (file_exists($filePath)) {
                unlink($filePath);
            }
            $emendaArquivoModel->delete($arquivo['id']);
        }

        // Deleta a emenda
        $emendaModel->delete($id);

        // Mensagem de sucesso
        session()->setFlashdata('success', 'Emenda e arquivos excluídos com sucesso!');

        // Redireciona para a listagem de emendas
        return redirect()->to('/emenda');
    }

    public function deleteArquivo($arquivoId)
    {
        $emendaArquivoModel = new EmendaArquivoModel();
        $arquivo = $emendaArquivoModel->find($arquivoId);

        if ($arquivo) {
            $filePath = WRITEPATH . 'uploads/' . $arquivo['caminho']; // Caminho completo para o arquivo
            if (file_exists($filePath)) {
                unlink($filePath); // Remove o arquivo do sistema de arquivos
            }
            $emendaArquivoModel->delete($arquivoId); // Remove o registro do banco de dados

            session()->setFlashdata('success', 'Arquivo excluído com sucesso!');
        } else {
            session()->setFlashdata('error', 'Arquivo não encontrado.');
        }

        // Redireciona de volta para a edição da emenda
        return redirect()->back();
    }

    public function publicView()
    {
        $anoModel = new AnoModel();
        $data['anos'] = $anoModel->findAll();

        return view('emenda/public_view', $data);
    }

    public function fetchEmendasByYear($ano_id)
    {
        $emendaModel = new EmendaModel();

        // Buscar emendas pelo ano
        $emendas = $emendaModel->where('ano_id', $ano_id)->findAll();

        return $this->response->setJSON($emendas);
    }
    public function fetchArquivosByEmenda($emenda_id)
    {
        $emendaArquivoModel = new EmendaArquivoModel();
        $arquivos = $emendaArquivoModel->where('emenda_id', $emenda_id)->findAll();

        return $this->response->setJSON($arquivos);
    }



}