<?php

namespace App\Controllers;

use App\Models\TipoModel;
use App\Models\AnoModel;
use CodeIgniter\Controller;

class Tipo extends Controller
{
    public function index()
    {
        $model = new TipoModel();
        $data['tipos'] = $model->getTiposWithAno();
        return view('tipos/index', $data);
    }

    public function create()
    {
        $anoModel = new AnoModel();
        $data['anos'] = $anoModel->findAll();
        return view('tipos/create', $data);
    }

    public function store()
    {
        $model = new TipoModel();
        $data = [
            'ano_id' => $this->request->getPost('ano_id'),
            'nome'   => $this->request->getPost('nome'),
        ];
        $model->save($data);
        return redirect()->to('/tipos');
    }

    public function delete($id)
    {
        $model = new TipoModel();
        $model->delete($id);
        return redirect()->to('/tipos');
    }
}
