<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateTiposTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'unsigned'       => true,
                'auto_increment' => true
            ],
            'ano_id' => [
                'type'       => 'INT',
                'unsigned'   => true,
            ],
            'nome' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);

        $this->forge->addKey('id', true);
        $this->forge->addForeignKey('ano_id', 'anos', 'id', 'CASCADE', 'CASCADE');
        $this->forge->createTable('tipos');
    }

    public function down()
    {
        $this->forge->dropTable('tipos');
    }
}
