<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;
use App\Models\UsuarioModel;

class UsuarioSeeder extends Seeder
{
    public function run()
    {
        $usuarioModel = new UsuarioModel();

        // Verifica se o usuário já existe
        $existingUser = $usuarioModel->where('email', 'admin2@example.com')->first();

        if (!$existingUser) {
            $data = [
                'nome'     => 'Novo Admin',
                'email'    => 'admin2@example.com',
                'senha'    => password_hash('novasenha123', PASSWORD_DEFAULT),
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ];

            $usuarioModel->insert($data);
            echo "Usuário 'admin2@example.com' criado com sucesso.";
        } else {
            echo "Usuário já existe no banco de dados. Nenhuma inserção foi feita.";
        }
    }
}
