<?php

namespace App\Models;

use CodeIgniter\Model;

class EmendaArquivoModel extends Model
{
    protected $table      = 'emenda_arquivos';
    protected $primaryKey = 'id';
    protected $allowedFields = ['emenda_id', 'caminho', 'nome_arquivo', 'tipo', 'tamanho', 'created_at', 'updated_at'];
    protected $useTimestamps = true;

    /**
     * Obtém todos os arquivos associados a uma emenda específica.
     *
     * @param int $emendaId
     * @return array
     */
    public function getFilesByEmenda($emendaId)
    {
        return $this->where('emenda_id', $emendaId)->findAll();
    }
}
