<?php

namespace App\Models;

use CodeIgniter\Model;

class EmendaModel extends Model
{
    protected $table      = 'emendas';
    protected $primaryKey = 'id';
    protected $allowedFields = ['tipo_id', 'ano_id', 'numero', 'objeto', 'vereador', 'valor', 'suplementacao', 'total', 'dotacao', 'empenho', 'situacao'];
    protected $useTimestamps = true;

    /**
     * Obtém todas as emendas com o nome do tipo associado.
     *
     * @return array
     */
    public function getEmendasWithTipo()
    {
        return $this->select('emendas.*, tipos.nome as tipo_nome')
            ->join('tipos', 'tipos.id = emendas.tipo_id')
            ->findAll();
    }

    /**
     * Obtém uma emenda com todos os arquivos associados.
     *
     * @param int $id
     * @return array
     */
    public function getEmendaWithFiles($id)
    {
        $emenda = $this->find($id);
        if ($emenda) {
            $emendaArquivoModel = new \App\Models\EmendaArquivoModel();
            $emenda['arquivos'] = $emendaArquivoModel->getFilesByEmenda($id);
        }
        return $emenda;
    }
    public function edit($id)
    {
        $emendaModel = new EmendaModel();
        $tipoModel = new TipoModel();
        $emendaArquivoModel = new EmendaArquivoModel();

        // Verificar se o ID é válido
        $data['emenda'] = $emendaModel->find($id);
        if (!$data['emenda']) {
            throw new \CodeIgniter\Exceptions\PageNotFoundException('Emenda não encontrada');
        }

        $data['tipos'] = $tipoModel->findAll();
        $data['arquivos'] = $emendaArquivoModel->where('emenda_id', $id)->findAll();

        // Verifique se os arquivos realmente existem no servidor antes de passar para a view
        foreach ($data['arquivos'] as $key => $arquivo) {
            $filePath = WRITEPATH . 'uploads/' . $arquivo['file_path'];
            if (!file_exists($filePath)) {
                unset($data['arquivos'][$key]);
                log_message('error', 'Arquivo não encontrado: ' . $filePath);
            }
        }

        return view('emenda/edit', $data);
    }


}
