<?php

namespace App\Models;

use CodeIgniter\Model;

class TipoModel extends Model
{
    protected $table      = 'tipos';
    protected $primaryKey = 'id';
    protected $allowedFields = ['ano_id', 'nome'];
    protected $useTimestamps = true;

    public function getTiposWithAno()
    {
        return $this->select('tipos.*, anos.ano')
            ->join('anos', 'anos.id = tipos.ano_id')
            ->findAll();
    }
}
