<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/materialize/1.0.0/css/materialize.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <link href="/assets/css/style.css" rel="stylesheet">
</head>
<body>
<div class="container">
    <div class="form-container">
        <h5 class="center-align">Login</h5>
        <?php if (session()->getFlashdata('error')): ?>
            <div class="card-panel red lighten-2">
                <?= session()->getFlashdata('error') ?>
            </div>
        <?php endif; ?>
        <form action="/auth/authenticate" method="post">
            <div class="input-field">
                <input id="email" type="email" name="email" class="validate" required>
                <label for="email">Email</label>
            </div>
            <div class="input-field" style="position: relative;">
                <input id="senha" type="password" name="senha" class="validate" required>
                <label for="senha">Senha</label>
                <i class="material-icons show-password" style="position: absolute; right: 10px; top: 50%; transform: translateY(-50%); cursor: pointer;">visibility</i>
            </div>
            <p>
                <label>
                    <input type="checkbox" id="remember-me" name="remember_me" />
                    <span>Manter conectado</span>
                </label>
            </p>
            <div class="center-align">
                <button type="submit" class="btn blue">Entrar</button>
            </div>
        </form>
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/materialize/1.0.0/js/materialize.min.js"></script>
<script src="/assets/js/main.js"></script>
</body>
</html>
