<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?? 'Admin Dashboard' ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bulma@0.9.3/css/bulma.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
    <link href="/assets/css/custom-dashboard.css" rel="stylesheet"> <!-- CSS Customizado -->
    <style>
        /* Esconde os submenus por padrão */
        .menu-list ul {
            display: none;
        }
        /* Exibe o submenu quando ativo */
        .menu-list li.is-active > ul {
            display: block;
        }
        /* Ajusta o espaçamento e o estilo para responsividade */
        @media (max-width: 768px) {
            .sidebar {
                display: none;
            }
            .sidebar.is-active {
                display: block;
            }
        }
    </style>
</head>
<body class="dashboard-body">

<!-- Navbar -->
<nav class="navbar is-primary">
    <div class="navbar-brand">
        <a href="/dashboard" class="navbar-item">Admin Dashboard</a>
        <a role="button" class="navbar-burger" aria-label="menu" aria-expanded="false" data-target="sidebarMenu">
            <span aria-hidden="true"></span>
            <span aria-hidden="true"></span>
            <span aria-hidden="true"></span>
        </a>
    </div>
    <div class="navbar-menu">
        <div class="navbar-end">
            <a class="navbar-item" href="#"><span class="icon"><i class="fas fa-user-circle"></i></span> Usuário</a>
            <a class="navbar-item" href="/logout"><span class="icon"><i class="fas fa-sign-out-alt"></i></span> Logout</a>
        </div>
    </div>
</nav>

<div class="columns is-gapless">
    <!-- Sidebar -->
    <aside id="sidebarMenu" class="column is-2 has-background-light sidebar">
        <div class="menu">
            <p class="menu-label">Menu</p>
            <ul class="menu-list">
                <li><a href="/dashboard"><span class="icon"><i class="fas fa-tachometer-alt"></i></span> Dashboard</a></li>

                <!-- Submenu para Anos com efeito de abrir/fechar -->
                <li>
                    <a class="has-icon" onclick="toggleMenu(this)"><span class="icon"><i class="fas fa-calendar-alt"></i></span> Anos</a>
                    <ul>
                        <li><a href="/anos">Listar Anos</a></li>
                        <li><a href="/anos/create">Cadastrar Novo Ano</a></li>
                    </ul>
                </li>

                <!-- Submenu para Tipos com efeito de abrir/fechar -->
                <li>
                    <a class="has-icon" onclick="toggleMenu(this)"><span class="icon"><i class="fas fa-tags"></i></span> Tipos</a>
                    <ul>
                        <li><a href="/tipos">Listar Tipos</a></li>
                        <li><a href="/tipos/create">Cadastrar Novo Tipo</a></li>
                    </ul>
                </li>

                <li>
                    <a class="has-icon" onclick="toggleMenu(this)"><span class="icon"><i class="fas fa-file-alt"></i></span> Emendas</a>
                    <ul>
                        <li><a href="/emenda">Listar Emendas</a></li>
                        <li><a href="/emenda/create">Cadastrar Nova Emenda</a></li>
<!--                        <li><a href="/emenda/edit">Editar Emenda</a></li>-->
                    </ul>
                </li>
                <li><a href="#"><span class="icon"><i class="fas fa-file-alt"></i></span> Documentos</a></li>
            </ul>
        </div>
    </aside>

    <!-- Main Content -->
    <div class="column is-10">
        <section class="section">
            <?= $this->renderSection('content') ?>
        </section>
    </div>
</div>

<footer class="footer has-background-primary">
    <div class="content has-text-centered has-text-white">
        © 2024 Sistema de Gestão
    </div>
</footer>

<script>
    // Função para abrir/fechar submenus
    function toggleMenu(element) {
        element.parentNode.classList.toggle("is-active");
    }

    // Ativar e desativar a sidebar no mobile
    document.addEventListener('DOMContentLoaded', () => {
        const burger = document.querySelector('.navbar-burger');
        const sidebar = document.querySelector('.sidebar');
        burger.addEventListener('click', () => {
            sidebar.classList.toggle('is-active');
            burger.classList.toggle('is-active');
        });
    });
</script>

</body>
</html>
