<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Emendas por Ano</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:300,400,500,700&display=swap" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@mui/material@5.0.0-beta.3/dist/material-ui.min.css" />
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f5f5f5;
            color: #333;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }

        .year-buttons {
            display: flex;
            justify-content: center;
            margin-bottom: 20px;
        }

        .year-buttons button {
            margin-right: 10px;
        }

        .section-header {
            margin-top: 20px;
            margin-bottom: 10px;
            font-size: 20px;
            font-weight: bold;
            color: #007bff;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            background-color: white;
            border-radius: 5px;
            overflow: hidden;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        th, td {
            padding: 10px;
            text-align: left;
        }

        th {
            background-color: #007bff;
            color: white;
        }

        .executada {
            background-color: #a3e4d7;
        }

        .impedimento-tecnico {
            background-color: #f9e79f;
        }

        .em-execucao {
            background-color: #f5b7b1;
        }

        .pdf-icon {
            color: red;
            cursor: pointer;
            margin-left: 10px;
            animation: bounce 1s infinite alternate;
        }

        @keyframes bounce {
            0% { transform: translateY(0); }
            100% { transform: translateY(-5px); }
        }

        /* Modal styles */
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            justify-content: center;
            align-items: center;
            z-index: 1000;
        }

        .modal-content {
            background-color: white;
            padding: 20px;
            border-radius: 8px;
            max-width: 600px;
            width: 100%;
            text-align: center;
        }

        .pdf-preview {
            display: flex;
            justify-content: space-around;
            flex-wrap: wrap;
            margin-bottom: 20px;
        }

        .pdf-preview div {
            text-align: center;
            margin: 10px;
        }

        .pdf-preview i {
            font-size: 50px;
            color: red;
        }
    </style>
</head>
<body>
<header>
    <div class="mui-container mui-container--fluid">
        <h1 style="text-align: center; padding: 20px; background-color: #007bff; color: white; margin: 0;">
            Sistema de Emendas - Visualização por Ano
        </h1>
    </div>
</header>

<div class="container">
    <div class="year-buttons">
        <button class="mui-button mui-button--contained mui-button--primary" onclick="showTable('2021-2022')">2021-2022</button>
        <button class="mui-button mui-button--contained mui-button--primary" onclick="showTable('2023')">2023</button>
        <button class="mui-button mui-button--contained mui-button--primary" onclick="showTable('2024')">2024</button>
    </div>

    <div id="2021-2022" class="table-container active">
        <!-- Planejamento -->
        <h2 class="section-header">Planejamento</h2>
        <table>
            <thead>
            <tr>
                <th>Emenda</th>
                <th>Objeto</th>
                <th>Vereador</th>
                <th>Valor</th>
                <th>Suplementação</th>
                <th>Total</th>
                <th>Dotação</th>
                <th>Empenho</th>
                <th>Situação</th>
            </tr>
            </thead>
            <tbody>
            <tr>
                <td>0051</td>
                <td>
                    PAV RUA VEREADOR CARBONEL
                    <i class="fas fa-file-pdf pdf-icon" onclick="openModal()"></i>
                </td>
                <td>CLEO TRINDADE</td>
                <td>R$ 104,291.33</td>
                <td>R$ 218,872.04</td>
                <td>R$ 323,163.37</td>
                <td>15226</td>
                <td>5659</td>
                <td class="executada">EXECUTADA</td>
            </tr>
            </tbody>
        </table>

        <!-- Educação -->
        <h2 class="section-header">Educação</h2>
        <table>
            <thead>
            <tr>
                <th>Emenda</th>
                <th>Objeto</th>
                <th>Vereador</th>
                <th>Valor</th>
                <th>Suplementação</th>
                <th>Total</th>
                <th>Dotação</th>
                <th>Empenho</th>
                <th>Situação</th>
            </tr>
            </thead>
            <tbody>
            <tr>
                <td>0002</td>
                <td>
                    Materiais para cercamento - Quadras
                    <i class="fas fa-file-pdf pdf-icon" onclick="openModal()"></i>
                </td>
                <td>DILEUSA ALVES</td>
                <td>R$ 70,000.00</td>
                <td>R$ 0.00</td>
                <td>R$ 70,000.00</td>
                <td>13879</td>
                <td>-</td>
                <td class="executada">EXECUTADA</td>
            </tr>
            </tbody>
        </table>

        <!-- Assistência -->
        <h2 class="section-header">Assistência</h2>
        <table>
            <thead>
            <tr>
                <th>Emenda</th>
                <th>Objeto</th>
                <th>Vereador</th>
                <th>Valor</th>
                <th>Suplementação</th>
                <th>Total</th>
                <th>Dotação</th>
                <th>Empenho</th>
                <th>Situação</th>
            </tr>
            </thead>
            <tbody>
            <tr>
                <td>0041</td>
                <td>
                    Mão de Obra - Casa de Passagem
                    <i class="fas fa-file-pdf pdf-icon" onclick="openModal()"></i>
                </td>
                <td>JAIME DUARTE</td>
                <td>R$ 34,291.33</td>
                <td>R$ 0.00</td>
                <td>R$ 34,291.33</td>
                <td>15227</td>
                <td>-</td>
                <td class="em-execucao">EM EXECUÇÃO - NÃO CONCLUÍDA</td>
            </tr>
            </tbody>
        </table>
    </div>

    <div class="modal" id="pdfModal">
        <div class="modal-content">
            <h3>Documentos Anexados</h3>
            <div class="pdf-preview">
                <div>
                    <i class="fas fa-file-pdf"></i>
                    <p><button class="mui-button mui-button--contained mui-button--secondary">Download PDF 1</button></p>
                </div>
                <div>
                    <i class="fas fa-file-pdf"></i>
                    <p><button class="mui-button mui-button--contained mui-button--secondary">Download PDF 2</button></p>
                </div>
                <div>
                    <i class="fas fa-file-pdf"></i>
                    <p><button class="mui-button mui-button--contained mui-button--secondary">Download PDF 3</button></p>
                </div>
                <div>
                    <i class="fas fa-file-pdf"></i>
                    <p><button class="mui-button mui-button--contained mui-button--secondary">Download PDF 4</button></p>
                </div>
                <div>
                    <i class="fas fa-file-pdf"></i>
                    <p><button class="mui-button mui-button--contained mui-button--secondary">Download PDF 5</button></p>
                </div>
                <div>
                    <i class="fas fa-file-pdf"></i>
                    <p><button class="mui-button mui-button--contained mui-button--secondary">Download PDF 6</button></p>
                </div>
            </div>
            <button class="mui-button mui-button--contained mui-button--primary" onclick="closeModal()">Fechar</button>
        </div>
    </div>
</div>

<script>
    function showTable(year) {
        const tables = document.querySelectorAll('.table-container');
        tables.forEach(table => table.classList.remove('active'));
        document.getElementById(year).classList.add('active');
    }

    function openModal() {
        document.getElementById('pdfModal').style.display = 'flex';
    }

    function closeModal() {
        document.getElementById('pdfModal').style.display = 'none';
    }

    showTable('2021-2022');
</script>
</body>
</html>
