<?= $this->extend('layout/layout') ?>

<?= $this->section('content') ?>
<div class="container mt-5">
    <h1 class="title is-4">Gerenciar Tipos</h1>
    <a href="/tipos/create" class="button is-primary mb-3">Adicionar Novo Tipo</a>
    <table class="table is-fullwidth is-striped">
        <thead>
        <tr>
            <th>ID</th>
            <th>Nome</th>
            <th>Ano</th>
            <th>Ações</th>
        </tr>
        </thead>
        <tbody>
        <?php foreach ($tipos as $tipo): ?>
            <tr>
                <td><?= $tipo['id'] ?></td>
                <td><?= $tipo['nome'] ?></td>
                <td><?= $tipo['ano'] ?></td>
                <td>
                    <a href="/tipos/delete/<?= $tipo['id'] ?>" class="button is-danger is-small">Excluir</a>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>
<?= $this->endSection() ?>
