<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Emendas por Ano</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:300,400,500,700&display=swap" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        /* Estilos Gerais */
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f5f5f5;
            color: #333;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }

        /* Estilo do Header */
        header {
            background-color: #003b7a;
            color: white;
            padding: 10px 0;
        }

        .header-top {
            display: flex;
            justify-content: space-between;
            padding: 5px 20px;
            font-size: 12px;
            background-color: #002a5c;
        }

        .header-top a {
            color: white;
            margin-right: 15px;
            text-decoration: none;
            font-weight: 500;
        }

        .header-top a:hover {
            text-decoration: underline;
        }

        .header-main {
            text-align: center;
            padding: 20px;
        }

        .header-main h1 {
            font-size: 28px;
            font-weight: bold;
            margin-bottom: 5px;
        }

        .header-main h2 {
            font-size: 14px;
            font-weight: 300;
        }

        .nav-bar {
            background-color: #0058b0;
            padding: 10px 0;
        }

        .nav-bar ul {
            display: flex;
            justify-content: center;
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .nav-bar li {
            margin: 0 20px;
            font-size: 14px;
            font-weight: bold;
            color: white;
            cursor: pointer;
        }

        .nav-bar li:hover {
            text-decoration: underline;
        }

        .search-bar {
            display: flex;
            justify-content: center;
            margin-top: 15px;
        }

        .search-bar input {
            padding: 10px;
            width: 300px;
            border-radius: 5px 0 0 5px;
            border: none;
            outline: none;
        }

        .search-bar .search-button {
            padding: 10px;
            background-color: #0058b0;
            color: white;
            border-radius: 0 50px 50px 50px;
            border: none;
            cursor: pointer;
            margin-right: 10px;
        }

        /* Estilo do Footer */
        footer {
            background-color: #003b7a;
            color: white;
            padding: 20px 0;
            text-align: center;
            font-size: 14px;
            margin-top: 40px;
        }

        footer .footer-links {
            margin: 10px 0;
        }

        footer .footer-links a {
            color: white;
            margin: 0 10px;
            text-decoration: none;
        }

        footer .footer-links a:hover {
            text-decoration: underline;
        }

        /* Estilos da Tabela e Botões */
        .year-buttons {
            display: flex;
            justify-content: center;
            margin-bottom: 20px;
        }

        .year-buttons button {
            margin-right: 10px;
        }

        .section-header {
            margin-top: 20px;
            margin-bottom: 10px;
            font-size: 20px;
            font-weight: bold;
            color: #00295b;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            background-color: white;
            border-radius: 5px;
            overflow: hidden;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        th, td {
            padding: 10px;
            text-align: left;
        }

        th {
            background-color: #0058b0;
            color: white;
        }

        /* Cores de Status */
        .executada {
            background-color: #a3e4d7;
        }

        .impedimento-tecnico {
            background-color: #f9e79f;
        }

        .em-execucao {
            background-color: #f5b7b1;
        }

        /* Modal */
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            justify-content: center;
            align-items: center;
            z-index: 1000;
        }

        .modal-content {
            background-color: white;
            padding: 20px;
            border-radius: 8px;
            max-width: 600px;
            width: 100%;
            text-align: center;
        }
        /* Estilo para o Modo de Alto Contraste */
        .high-contrast {
            background-color: black;
            color: yellow;
        }

        .high-contrast header,
        .high-contrast footer {
            background-color: black;
            color: yellow;
        }

        .high-contrast .nav-bar {
            background-color: yellow;
            color: black;
        }

        .high-contrast .search-bar input {
            background-color: #333;
            color: yellow;
            border: 1px solid yellow;
        }

        .high-contrast .search-bar .search-button {
            background-color: yellow;
            color: black;
        }

    </style>
</head>
<body>

<header>
    <div class="header-top">
        <div>
            <a href="#conteudo">Ir para o conteúdo</a>
            <a href="#menu">Ir para o menu</a>
            <a href="#busca">Ir para a busca</a>
            <a href="#rodape">Ir para o rodapé</a>
        </div>
        <div>
            <a href="#">A+</a>
            <a href="#">A-</a>
            <a href="#">ALTO CONTRASTE</a>
            <a href="#">MAPA DO SITE</a>
        </div>
    </div>
    <div class="header-main">
        <h1>Portal da Transparência</h1>
        <h2>Alegrete - RS</h2>
    </div>
    <nav class="nav-bar">
        <ul>
            <li>Sobre o Portal</li>
            <li>Painéis</li>
            <li>Consultas Detalhadas</li>
            <li>Controle Social</li>
            <li>Receba Notificações</li>
            <li>Aprenda Mais</li>
        </ul>
    </nav>

    <div class="search-bar">
        <?php foreach ($anos as $ano): ?>
            <button class="search-button" onclick="showTable('<?= esc($ano['ano']) ?>')"><?= esc($ano['ano']) ?></button>
        <?php endforeach; ?>
    </div>
</header>

<div class="container">


    <!-- Agrupamento das emendas por tipo -->
    <div id="2021-2022" class="table-container active">
        <?php
        $tipoAtual = null;
        foreach ($emendas as $emenda):
        // Verificar se o tipo atual mudou e iniciar uma nova seção
        if ($tipoAtual !== $emenda['tipo_nome']):
        if ($tipoAtual !== null): ?>
            </tbody>
            </table>
        <?php endif;
        $tipoAtual = $emenda['tipo_nome'];
        ?>
        <h2 class="section-header"><?= esc($tipoAtual) ?></h2>
        <table>
            <thead>
            <tr>
                <th>Emenda</th>
                <th>Objeto</th>
                <th>Vereador</th>
                <th>Valor</th>
                <th>Suplementação</th>
                <th>Total</th>
                <th>Dotação</th>
                <th>Empenho</th>
                <th>Situação</th>
            </tr>
            </thead>
            <tbody>
            <?php endif; ?>

            <tr>
                <td><?= esc($emenda['numero']) ?></td>
                <td>
                    <?= esc($emenda['objeto']) ?>
                    <i class="fas fa-file-pdf pdf-icon" onclick="openModal(<?= esc($emenda['id']) ?>)"></i>
                </td>
                <td><?= esc($emenda['vereador']) ?></td>
                <td>R$ <?= number_format($emenda['valor'], 2, ',', '.') ?></td>
                <td>R$ <?= number_format($emenda['suplementacao'], 2, ',', '.') ?></td>
                <td>R$ <?= number_format($emenda['total'], 2, ',', '.') ?></td>
                <td><?= esc($emenda['dotacao']) ?></td>
                <td><?= esc($emenda['empenho']) ?></td>
                <td class="executada"><?= esc($emenda['situacao']) ?></td>
            </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>


    <!-- Modal for PDF files -->
    <div class="modal" id="pdfModal">
        <div class="modal-content">
            <h3>Documentos Anexados</h3>
            <div id="pdfLinks">
                <!-- Links para arquivos PDF serão injetados aqui -->
            </div>
            <button class="mui-button mui-button--contained mui-button--primary" onclick="closeModal()">Fechar</button>
        </div>
    </div>
</div>

<footer>
    <div class="footer-links">
        <a href="#">Sobre</a>
        <a href="#">Política de Privacidade</a>
        <a href="#">Acessibilidade</a>
        <a href="#">Contato</a>
    </div>
    <p>© 2024 Portal da Transparência - Todos os direitos reservados</p>
</footer>
<script>
    const emendas = <?= json_encode($emendas) ?>; // Dados das emendas para acessar os arquivos

    function showTable(year) {
        const tables = document.querySelectorAll('.table-container');
        tables.forEach(table => table.classList.remove('active'));
        document.getElementById(year).classList.add('active');
    }

    function openModal(emendaId) {
        const pdfModal = document.getElementById('pdfModal');
        const pdfLinksContainer = document.getElementById('pdfLinks');

        // Limpar os links anteriores
        pdfLinksContainer.innerHTML = '';

        // Encontrar a emenda com o ID específico
        const emenda = emendas.find(e => e.id === emendaId);
        if (emenda && emenda.arquivos) {
            emenda.arquivos.forEach(arquivo => {
                const link = document.createElement('a');
                link.href = arquivo.caminho; // Link para download
                link.target = '_blank';
                link.innerText = arquivo.nome_arquivo;
                link.style.display = 'block';
                pdfLinksContainer.appendChild(link);
            });
        } else {
            pdfLinksContainer.innerHTML = '<p>Nenhum arquivo anexado.</p>';
        }

        pdfModal.style.display = 'flex';
    }

    function closeModal() {
        document.getElementById('pdfModal').style.display = 'none';
    }
</script>
<script>
    // Função para aumentar e diminuir o tamanho da fonte
    document.querySelectorAll('.header-top a').forEach(link => {
        link.addEventListener('click', (event) => {
            const body = document.body;
            if (event.target.textContent === 'A+') {
                let currentSize = parseFloat(window.getComputedStyle(body, null).getPropertyValue('font-size'));
                body.style.fontSize = (currentSize + 1) + 'px';
            } else if (event.target.textContent === 'A-') {
                let currentSize = parseFloat(window.getComputedStyle(body, null).getPropertyValue('font-size'));
                body.style.fontSize = (currentSize - 1) + 'px';
            }
        });
    });

</script>
<script>
    // Função para aumentar e diminuir o tamanho da fonte
    document.querySelectorAll('.header-top a').forEach(link => {
        link.addEventListener('click', (event) => {
            const body = document.body;
            if (event.target.textContent === 'A+') {
                let currentSize = parseFloat(window.getComputedStyle(body, null).getPropertyValue('font-size'));
                body.style.fontSize = (currentSize + 1) + 'px';
            } else if (event.target.textContent === 'A-') {
                let currentSize = parseFloat(window.getComputedStyle(body, null).getPropertyValue('font-size'));
                body.style.fontSize = (currentSize - 1) + 'px';
            } else if (event.target.textContent === 'ALTO CONTRASTE') {
                // Alternar o modo de alto contraste
                document.body.classList.toggle('high-contrast');
            }
        });
    });
</script>

</body>
</html>
